// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.1
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?[esp]
//

#version 3.1

#include "colors.inc"
#include "textures.inc"
#include "boat.inc"
#include "vase.inc" 
#include "full_col.inc"
#include "school.inc"
#include "bk1_column.inc"

//-----------------------------------------Atmosphere and Global----------------------------

global_settings
{
  assumed_gamma 1.0
} 




fog
{
  fog_type 1
  distance 200
 color 
         rgbf <0.137255, 0.419608, 0.556863, 0.0>
         
  turbulence 0.8
  turb_depth 0.7
 fog_alt -11.1
}





camera
{ 
  location <1,0.01,-80>  //normal
  //location  <0.5, 1300, 20> //looking down
   //location <1.0, -20, -50> //closer
  direction 1.5*z
  right     4/3*x
  //look_at   <0.5, -20,  200>
  look_at   <1, 0.03,  40.5> //normal
}



light_source
{
  0*x                     // light's position (translated below)
  color 400000 rgb <1,1,1>       // light's color
  //spotlight               // this kind of light source
  translate <60.5, 80, 240> // <x y z> position of light
   //shadowless
   looks_like  {


//difference {
 sphere { <60, 80, 250>, 7 pigment { White } 
  finish {
          specular 0.25
        roughness 1
        ambient 3 
        diffuse 0.33
         } 
  //media_interaction on
  
} }}

//sphere { <33, 61, 188.1>, 5 pigment { White } 
//  finish {
//          specular 0.25
//        roughness 1
//        ambient 0.0 
//        diffuse 0.33
//         }scale <2, 1.3, 1.3> 
  //media_interaction on
//  }}}} //end difference  

sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}


// Sandy Bottom
#declare bottom =
height_field
{
  png               
  "floor.png"
  texture
  {
    pigment
    {
      image_map { png               
  "sandy.png" map_type 0 interpolate 2  }
      rotate y*45 
    scale 0.4
    }
   
  
  }
  scale <350,45,300>
translate <-160,-60,-30>
smooth   
finish {ambient 0.18}
}


// vegitation
#declare veggies =
height_field
{
  png               
  "floor2.png"
  texture
  {
    pigment
    {
      image_map { png               
  "floor2_map.png" map_type 0 interpolate 2  }
      rotate y*45 
    scale 0.4
    }
   
  
  }
  scale <350,45,300>
translate <-160,-65.85,-30>
smooth   
finish {ambient 0.18}
}



 
// Top of water with radical bump texture

#declare swirls=
box
{
  <-800, -1, -800>  
  < 800,  -0.8,  800>


//plane
//{
//  y, 
//  -1.0 

texture {
    pigment{ rgbf <0.372549, 0.623529, 0.623529, 1> }
    normal {
        waves 0.05
        frequency 0.288
    }
    finish {
        reflection 0.003
#version -1.0;
        //refraction 0.3
        ior 1.33
        roughness 0.075
    }
#version 3.1;
}


        //rotate 42*y
        translate <225,0,-250>}


//Rock Layer
#declare rocks =
height_field
{
  png               // the file type to read (gif/tga/pot/pgm/ppm/png/sys)
  "road.png"     // the file name to read
     smooth        // make smoother surface

pigment {
    wood
    turbulence 0.6
    color_map {
        [0.0 rgb <0.88, 0.71, 0.53>]
        [0.8 rgb <0.83, 0.81, 0.60>]
        [0.8 rgb <0.60, 0.33, 0.27>]
        [1.0 rgb <0.70, 0.60, 0.23>]
    }
}
finish {ambient 0.18}
scale <390,11,290>
}




// Bow Light
light_source
{
  0*x                     
  color 400000 rgb <1,1,1>       
  spotlight               
  translate <-2,2.7,60> 
  point_at <-20, -110, 60>      
  radius 20                
  tightness 30            
  falloff 80               
  looks_like {sphere {1 0.3}
                hollow on
                pigment {rgb 1}
                finish {ambient 1}
                }
                media_interaction on}



// Starboard light 
light_source
{
  0*x                     
  color 400000 rgb <1,1,1>       
  spotlight               
  translate <13.2,2.85,56> 
  point_at <30, -110, 160>      
  radius 20                
  tightness 30            
  falloff 80               
  looks_like {sphere {1 0.3}
                hollow on
                pigment {rgb 1}
                finish {ambient 1}
}media_interaction on}


// Port light
light_source
{
  0*x                     
  color 400000 rgb <1,1,1>       
 spotlight               
  translate <13,2.85,62> 
  point_at <40, -110, 40>      
  radius 20                
  tightness 30            
  falloff 80               
  looks_like {sphere {1 0.3}
                hollow on
                pigment {rgb 1}
                finish {ambient 1}
}media_interaction on}

 
 
 object {bottom} //sea floor
 
 object { rocks
          translate <-150.77, -45, -20> 
           }
           
 object { veggies }          
            

 
 object {vase
        translate <-5.4,-17.3,29>
        scale 2}
        
 object {vase2
        translate <3,-17.7,52>
        scale 2}       
        
 object {swirls
        translate <1,8,1>}
 
 
 object {boat
       translate <0,5.4,30>
       scale 2
        }
        
 object {full_col 
         translate <6,-12.8,25.2>
         scale 3}
         
 object {broke
         translate <15.1,-33.8,60>
         }
         
 object {broke1
         translate <1,-30,70>
          }        


  object { school 
           translate <-0.001, 4, -0.4> }
  
  object { school 
           translate <-7, 3.5, 1> } 
           
 object { school 
           translate <-3.5, 3.75, -0.2> }          
    
    
                                      